/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.BackwardMaterialQuotas;
import cz.insophy.inplan.store.ForwardMaterialQuotas;
import cz.insophy.inplan.store.MaterialQuotas;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.util.AbstractComparableIterator;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.JointIterator;
import cz.insophy.inplan.util.SimpleComparableIterator;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Tuple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractStoreSchedule
implements StoreSchedule {
    protected Map<Material, List<StoreActivity>> activities;
    private final Map<Material, AtomicInteger> matActListVers = Maps.newIdentityHashMap();

    protected AbstractStoreSchedule(Collection<? extends Material> materials) {
        for (Material material : materials) {
            this.matActListVers.put(material, new AtomicInteger());
        }
    }

    @Override
    public double getQ(Material material, long time, boolean inclusive) {
        List<StoreActivity> matList = this.getMatActList(material);
        double q = 0.0;
        for (StoreActivity a : matList) {
            if (a.getTime() > time || a.getTime() == time && !inclusive) break;
            q += a.getQty();
        }
        return q;
    }

    protected Collection<List<StoreActivity>> getMatActLists() {
        return this.activities.values();
    }

    protected Collection<List<StoreActivity>> getMatActLists(Set<Material> mats) {
        HashSet<List<StoreActivity>> actLists = Sets.newHashSet();
        for (Material mat : mats) {
            actLists.add(this.getMatActList(mat));
        }
        return actLists;
    }

    protected List<StoreActivity> getMatActList(Material material) {
        List<StoreActivity> matList = this.activities.get(material);
        if (matList == null) {
            throw new IllegalStateException("Unknown material " + material);
        }
        return matList;
    }

    protected List<StoreActivity> getMatActList(StoreActivity activity) {
        if (activity == null) {
            throw new IllegalStateException("Activity cannot be null.");
        }
        List<StoreActivity> matList = this.activities.get(activity.getMaterial());
        if (matList == null) {
            throw new IllegalStateException("Unknown material in " + activity);
        }
        return matList;
    }

    @Override
    public List<StoreActivity> getActivities(Material material) {
        return Collections.unmodifiableList(this.getMatActList(material));
    }

    @Override
    public int getActivityCount() {
        int cnt = 0;
        for (List<StoreActivity> as : this.getMatActLists()) {
            cnt += as.size();
        }
        return cnt;
    }

    @Override
    public Set<Material> getMaterials() {
        return this.activities.keySet();
    }

    @Override
    public MaterialQuotas getInitialBackwardQuotas(Collection<Material> materials, long time) {
        return this.getInitialBackwardQuotas(materials, time, Predicates.alwaysTrue());
    }

    @Override
    public MaterialQuotas getInitialBackwardQuotas(Collection<Material> materials, long time, Predicate<StoreActivity> saPredicate) {
        return this.getInitialBackwardQuotas(materials, time, -9223372036854775708L, null, saPredicate);
    }

    @Override
    public MaterialQuotas getInitialBackwardQuotas(Collection<Material> materials, long time, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment, Predicate<StoreActivity> saPredicate) {
        return new BackwardMaterialQuotas(materials, time, matHorizonBase, matHorizonTreatment, this, saPredicate);
    }

    @Override
    public MaterialQuotas getInitialForwardQuotas(Collection<Material> materials, long time) {
        return this.getInitialForwardQuotas(materials, time, Predicates.alwaysTrue());
    }

    @Override
    public MaterialQuotas getInitialForwardQuotas(Collection<Material> materials, long time, Predicate<StoreActivity> saPredicate) {
        return this.getInitialForwardQuotas(materials, time, -9223372036854775708L, null, saPredicate);
    }

    @Override
    public MaterialQuotas getInitialForwardQuotas(Collection<Material> materials, long time, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment, Predicate<StoreActivity> saPredicate) {
        return new ForwardMaterialQuotas(materials, time, matHorizonBase, matHorizonTreatment, this, saPredicate);
    }

    @Override
    public Iterable<StoreActivity> activities() {
        return new Iterable<StoreActivity>(){

            @Override
            public Iterator<StoreActivity> iterator() {
                return AbstractStoreSchedule.this.sortedActivitiesIterator();
            }
        };
    }

    @Override
    public Iterable<StoreActivity> activities(final Set<Material> materials) {
        return new Iterable<StoreActivity>(){

            @Override
            public Iterator<StoreActivity> iterator() {
                return AbstractStoreSchedule.this.sortedActivitiesIterator(materials);
            }
        };
    }

    @Override
    public Iterator<StoreActivity> activitiesIterator() {
        return new AllActivitiesIterator();
    }

    @Override
    public Iterable<StoreActivity> sortedActivities() {
        return new Iterable<StoreActivity>(){

            @Override
            public Iterator<StoreActivity> iterator() {
                return AbstractStoreSchedule.this.sortedActivitiesIterator();
            }
        };
    }

    @Override
    public Iterator<StoreActivity> sortedActivitiesIterator() {
        return new JointStoreActsIterator(this.getMatActLists());
    }

    private Iterator<StoreActivity> sortedActivitiesIterator(Set<Material> materials) {
        return new JointStoreActsIterator(this.getMatActLists(materials));
    }

    @Override
    public Iterator<StoreActivity> sortedActivitiesIteratorFrom(long time) {
        return new JointStoreActsIterator(this.getMatActLists(), time);
    }

    @Override
    public Iterator<StoreActivity> sortedActivitiesIteratorFrom(Material material, long time) {
        return this.getMatActList(material).iterator();
    }

    @Override
    public Iterable<Tuple<Long, Double>> quantities(Material material) {
        return this.quantities(material, true);
    }

    @Override
    public Iterable<Tuple<Long, Double>> quantities(Material material, boolean aggregate) {
        return this.quantities(material, aggregate, Long.MIN_VALUE);
    }

    @Override
    public Iterable<Tuple<Long, Double>> quantities(Material material, long time) {
        return this.quantities(material, true, time);
    }

    @Override
    public Iterable<Tuple<Long, Double>> quantities(final Material material, final boolean aggregate, final long time) {
        return new Iterable<Tuple<Long, Double>>(){

            @Override
            public Iterator<Tuple<Long, Double>> iterator() {
                return AbstractStoreSchedule.this.quantityIterator(material, aggregate, time);
            }
        };
    }

    @Override
    public Iterator<Tuple<Long, Double>> quantityIterator(Material material) {
        return this.quantityIterator(material, true);
    }

    @Override
    public Iterator<Tuple<Long, Double>> quantityIterator(Material material, long time) {
        return this.quantityIterator(material, true, time);
    }

    @Override
    public Iterator<Tuple<Long, Double>> quantityIterator(Material material, boolean aggregate) {
        return this.quantityIterator(material, aggregate, Long.MIN_VALUE);
    }

    @Override
    public Iterator<Tuple<Long, Double>> quantityIterator(Material material, boolean aggregate, long time) {
        if (aggregate) {
            return new AggregatingMaterialQuantityIterator(this.getMatActList(material).iterator(), time);
        }
        return new MaterialQuantityIterator(this.getMatActList(material).iterator(), time);
    }

    @Override
    public boolean isBelow(Material material, double refQty, long ignoreUntil) {
        if (Double.isInfinite(refQty) || Double.isNaN(refQty)) {
            throw new IllegalStateException("Given reference qty is infinite or NaN: " + refQty);
        }
        List<StoreActivity> actList = this.getMatActList(material);
        double q = 0.0;
        if (actList.isEmpty() && Comparators.compare(q, refQty, 1.0E-7) < 0) {
            return true;
        }
        for (StoreActivity sa : actList) {
            if (sa.getTime() < ignoreUntil || Comparators.compare(q += sa.getQty(), refQty, 1.0E-7) >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBelowInfTime(Material material, double refQty) {
        return Comparators.compare(this.getInfTimeQty(material), refQty, 1.0E-7) < 0;
    }

    @Override
    public boolean isNegative(Material material) {
        return this.isBelow(material, 0.0, Long.MIN_VALUE);
    }

    @Override
    public boolean isNegativeInfTime(Material material) {
        return this.isBelowInfTime(material, 0.0);
    }

    @Override
    public double getInfTimeQty(Material material) {
        List<StoreActivity> actList = this.getMatActList(material);
        double qty = 0.0;
        for (StoreActivity sa : actList) {
            qty += sa.getQty();
        }
        return qty;
    }

    @Override
    public boolean containsActivity(StoreActivity act) {
        if (!this.activities.containsKey(act.getMaterial())) {
            return false;
        }
        return this.getMatActList(act).contains(act);
    }

    @Override
    public TimeSpan getTimeBounds() {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        for (List<StoreActivity> matList : this.getMatActLists()) {
            if (matList.size() <= 0) continue;
            long aStart = matList.get(0).getTime();
            long aEnd = matList.get(matList.size() - 1).getTime();
            if (aStart < start) {
                start = aStart;
            }
            if (aEnd <= end) continue;
            end = aEnd;
        }
        return TimeSpan.fromStartEnd(start, end);
    }

    protected void setVersion(Material m3, int newVersion) {
        AtomicInteger ver = this.matActListVers.get(m3);
        if (ver == null) {
            throw new IllegalArgumentException("Uknown material to set version for.");
        }
        ver.set(newVersion);
    }

    protected int getVersion(Material m3) {
        AtomicInteger ver = this.matActListVers.get(m3);
        if (ver == null) {
            throw new IllegalArgumentException("Uknown material to get version for.");
        }
        return ver.get();
    }

    protected int bumpVersion(Material m3) {
        AtomicInteger ver = this.matActListVers.get(m3);
        if (ver == null) {
            throw new IllegalArgumentException("Uknown material to bump version for.");
        }
        return ver.incrementAndGet();
    }

    protected void bumpAllVersions() {
        for (AtomicInteger v : this.matActListVers.values()) {
            v.incrementAndGet();
        }
    }

    private class AllActivitiesIterator
    implements Iterator<StoreActivity> {
        Iterator<List<StoreActivity>> matIt;
        Iterator<StoreActivity> saIt;
        StoreActivity next;

        private AllActivitiesIterator() {
            this.matIt = AbstractStoreSchedule.this.getMatActLists().iterator();
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            do {
                if (this.saIt != null && this.saIt.hasNext()) {
                    this.next = this.saIt.next();
                    return true;
                }
                this.saIt = this.matIt.hasNext() ? this.matIt.next().iterator() : null;
            } while (this.saIt != null);
            return false;
        }

        @Override
        public StoreActivity next() {
            if (this.next == null) {
                this.hasNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            StoreActivity sa = this.next;
            this.next = null;
            return sa;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class JointStoreActsIterator
    extends JointIterator<StoreActivity> {
        public JointStoreActsIterator(Collection<List<StoreActivity>> actLists) {
            super(JointStoreActsIterator.createIterators(actLists, Long.MIN_VALUE));
        }

        public JointStoreActsIterator(Collection<List<StoreActivity>> actLists, long start) {
            super(JointStoreActsIterator.createIterators(actLists, start));
        }

        private static Set<AbstractComparableIterator<StoreActivity>> createIterators(Collection<List<StoreActivity>> actLists, long start) {
            HashSet<AbstractComparableIterator<StoreActivity>> iters = Sets.newHashSet();
            for (List<StoreActivity> acts : actLists) {
                StoreActivitiesIterator newIt = new StoreActivitiesIterator(acts, start);
                iters.add(newIt);
            }
            return iters;
        }
    }

    private static class AggregatingMaterialQuantityIterator
    implements Iterator<Tuple<Long, Double>> {
        private final Iterator<StoreActivity> saIter;
        private double qty;
        private StoreActivity nextActivity;
        private long initialTime;

        public AggregatingMaterialQuantityIterator(Iterator<StoreActivity> iterator, long start) {
            this.saIter = iterator;
            this.initialTime = start;
            this.qty = 0.0;
            if (start > Long.MIN_VALUE) {
                StoreActivity sa = null;
                while (this.saIter.hasNext() && (sa = this.saIter.next()).getTime() <= start) {
                    this.qty += sa.getQty();
                    sa = null;
                }
                this.nextActivity = sa;
            } else {
                this.nextActivity = this.saIter.hasNext() ? this.saIter.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextActivity != null || this.initialTime > Long.MIN_VALUE || this.saIter.hasNext();
        }

        @Override
        public Tuple<Long, Double> next() {
            if (this.initialTime > Long.MIN_VALUE) {
                Tuple<Long, Double> res = Tuple.create(this.initialTime, this.qty);
                this.initialTime = Long.MIN_VALUE;
                return res;
            }
            if (this.nextActivity == null) {
                throw new NoSuchElementException();
            }
            long time = this.nextActivity.getTime();
            do {
                this.qty += this.nextActivity.getQty();
                this.nextActivity = null;
            } while (this.saIter.hasNext() && (this.nextActivity = this.saIter.next()).getTime() == time);
            return new Tuple<Long, Double>(time, this.qty);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MaterialQuantityIterator
    implements Iterator<Tuple<Long, Double>> {
        private final Iterator<StoreActivity> saIter;
        private double qty;
        private long initialTime;
        private StoreActivity nextSa;

        public MaterialQuantityIterator(Iterator<StoreActivity> iterator, long start) {
            this.saIter = iterator;
            this.qty = 0.0;
            this.initialTime = start;
            this.nextSa = null;
            while (this.saIter.hasNext()) {
                this.nextSa = this.saIter.next();
                if (this.nextSa.getTime() >= start) break;
                this.qty += this.nextSa.getQty();
                this.nextSa = null;
            }
            this.initialTime = this.nextSa != null && this.nextSa.getTime() == start ? Long.MIN_VALUE : start;
        }

        @Override
        public boolean hasNext() {
            return this.nextSa != null || this.initialTime > Long.MIN_VALUE || this.saIter.hasNext();
        }

        @Override
        public Tuple<Long, Double> next() {
            if (this.initialTime > Long.MIN_VALUE) {
                Tuple<Long, Double> res = Tuple.create(this.initialTime, this.qty);
                this.initialTime = Long.MIN_VALUE;
                return res;
            }
            StoreActivity sa = this.nextSa != null ? this.nextSa : this.saIter.next();
            this.nextSa = null;
            this.qty += sa.getQty();
            return new Tuple<Long, Double>(sa.getTime(), this.qty);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class StoreActivitiesIterator
    extends SimpleComparableIterator<StoreActivity> {
        public StoreActivitiesIterator(List<StoreActivity> acts, long start) {
            super(acts.listIterator(StoreActivitiesIterator.getStartIdx(acts, start)));
        }

        private static int getStartIdx(List<StoreActivity> acts, long start) {
            StoreActivity activity;
            int idx = 0;
            for (int i = 0; i < acts.size() && (activity = acts.get(i)).getTime() < start; ++i) {
                ++idx;
            }
            return idx;
        }
    }
}

